/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.EditUserPanelBean;
import com.ibm.hwmca.base.ntfy.NotificationAbstractTasklet;
import com.ibm.hwmca.base.ntfy.UserManagerPanelBean;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.MonitoredHashMap;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.NotifyClassProperties;
import com.ibm.hwmca.fw.ntfy.UserObject;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UserManagerTasklet
extends NotificationAbstractTasklet {
    private static final String TRACE_MASKT = "XNTYUMTT";
    private static final String TRACE_MASKF = "XNTYUMTF";
    private static final String TRACE_MASKD = "XNTYUMTD";
    private static final String CONFIG_MOUNT_POINT = "ConfigMP";
    private static final String UI_INFO_KEY = "uiinfo";
    private static final String USER_TASKLET_KEY = "usertasklet";

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String command;
        String source = (String)request.getData("CommandSource");
        if (source == null) {
            source = "";
        }
        if ((command = (String)request.getData("CommandName")) == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (request.isCanceled() || request.isDisposed() || command.equals("CANCEL") || command.equals("")) {
            this.serviceDisposed(request, response);
        } else if (source.equals("UserManagerPanel")) {
            this.serviceUserManagerPanel(request, response);
        } else if (source.equals("EditUserPanel")) {
            this.serviceEditUserPanel(request, response);
        } else if (command.equals("BounceCommand")) {
            this.serviceBounce(request, response);
        } else {
            this.unknownCommand(response, command);
        }
    }

    private void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32743;
        UserManagerPanelBean bean = new UserManagerPanelBean();
        bean.setBeanName("UserManagerPanel");
        Map users = NotificationService.getManager().getUsers();
        Map[] userMaps = new Map[users.size()];
        int i = 0;
        Iterator iterator = users.keySet().iterator();
        while (iterator.hasNext()) {
            String userName = (String)iterator.next();
            UserObject user = (UserObject)users.get(userName);
            userMaps[i] = new HashMap();
            userMaps[i].put("DataMapUserName", user.getName());
            userMaps[i].put("DataMapFullName", user.getDescription());
            userMaps[i].put("DataMapEnabled", new Boolean(user.isEnabled()));
            userMaps[i].put("DataMapOtherNotes", user.getAttribute(this.getClass().getName()));
            ++i;
        }
        HashMap<String, Object> beanData = new HashMap<String, Object>();
        beanData.put("UserTable", userMaps);
        beanData.put("EditMode", Boolean.TRUE);
        bean.setData(beanData);
        response.replace("com.ibm.hwmca.base.ntfy.res.NotificationRes", "UserManagerPanel", bean);
    }

    void serviceUserManagerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32743;
        String command = (String)request.getData("CommandName");
        if (command.equals("AddButton")) {
            EditUserPanelBean bean = new EditUserPanelBean();
            bean.setBeanName("EditUserPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditUserPanel", bean, null, null);
            Map sinkMap = NotificationService.getManager().getSinkClassPropertyMap();
            DisplayAreaDescriptor[] tabs = new DisplayAreaDescriptorDelegate[sinkMap.size()];
            HashMap delegateMap = new HashMap();
            Trace.trace(TRACE_MASKF, "number of sinks: " + sinkMap.size());
            int i = 0;
            Iterator iterator = sinkMap.keySet().iterator();
            while (iterator.hasNext()) {
                String sinkName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "sink name: " + sinkName);
                NotifyClassProperties sinkProps = (NotifyClassProperties)sinkMap.get(sinkName);
                Map sinkUI = (Map)sinkProps.get(UI_INFO_KEY);
                String taskletName = (String)sinkUI.get(USER_TASKLET_KEY);
                Trace.trace(TRACE_MASKF, "tasklet name:" + taskletName);
                tabs[i] = new DisplayAreaDescriptorDelegate(taskletName, delegateMap);
                ((DisplayAreaDescriptorDelegate)tabs[i]).setMountPoint(CONFIG_MOUNT_POINT);
                ++i;
            }
            this.mode = 1;
            response.openModalChild(frame, tabs);
        } else if (command.equals("EditButton")) {
            String user = (String)request.getData("TaskletSelectedUser");
            EditUserPanelBean bean = new EditUserPanelBean();
            bean.setBeanName("EditUserPanel");
            UserObject userObject = (UserObject)NotificationService.getManager().getUsers().get(user);
            HashMap<String, Object> beanMap = new HashMap<String, Object>();
            beanMap.put("DataMapUserName", user);
            beanMap.put("DataMapFullName", userObject.getDescription());
            beanMap.put("DataMapEnabled", new Boolean(userObject.isEnabled()));
            beanMap.put("DataMapOtherNotes", userObject.getAttribute(this.getClass().getName()));
            bean.setData(beanMap);
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditUserPanel", bean, null, null);
            Map sinkMap = NotificationService.getManager().getSinkClassPropertyMap();
            DisplayAreaDescriptor[] tabs = new DisplayAreaDescriptorDelegate[sinkMap.size()];
            HashMap<String, Object> delegateMap = new HashMap<String, Object>();
            delegateMap.put("UserName", request.getData("TaskletSelectedUser"));
            Trace.trace(TRACE_MASKF, "number of sinks: " + sinkMap.size());
            int i = 0;
            Iterator iterator = sinkMap.keySet().iterator();
            while (iterator.hasNext()) {
                String sinkName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "sink name: " + sinkName);
                NotifyClassProperties sinkProps = (NotifyClassProperties)sinkMap.get(sinkName);
                Map sinkUI = (Map)sinkProps.get(UI_INFO_KEY);
                String taskletName = (String)sinkUI.get(USER_TASKLET_KEY);
                Trace.trace(TRACE_MASKF, "tasklet name:" + taskletName);
                tabs[i] = new DisplayAreaDescriptorDelegate(taskletName, delegateMap);
                ((DisplayAreaDescriptorDelegate)tabs[i]).setMountPoint(CONFIG_MOUNT_POINT);
                ++i;
            }
            this.mode = 2;
            response.openModalChild(frame, tabs);
        } else if (command.equals("DeleteButton")) {
            if (this.okToDelete((String)request.getData("TaskletSelectedUser"))) {
                NotificationService.getManager().getUsers().remove((String)request.getData("TaskletSelectedUser"));
                HashMap<String, String> updateMap = new HashMap<String, String>();
                updateMap.put("CommandName", "DeleteButton");
                response.update("UserManagerPanel", updateMap);
            } else {
                response.noAction();
            }
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceEditUserPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32762;
        String command = (String)request.getData("CommandName");
        Map map = (Map)request.getData("TaskletDataMap");
        if (command.equals("ApplyButton") || command.equals("OKButton")) {
            if (this.mode == 1) {
                map.put("CommandName", "AddButton");
            } else if (this.mode == 2) {
                map.put("CommandName", "EditButton");
            }
            UserObject user = new UserObject((String)map.get("DataMapUserName"), (String)map.get("DataMapFullName"));
            user.setEnabled((Boolean)map.get("DataMapEnabled"));
            user.setAttribute(this.getClass().getName(), (Serializable)((Object)((String)map.get("DataMapOtherNotes"))));
            try {
                if (this.mode == 2) {
                    ((MonitoredHashMap)NotificationService.getManager().getUsers()).replace(user.getName(), user);
                } else {
                    NotificationService.getManager().getUsers().put((String)map.get("DataMapUserName"), user);
                }
                this.mode = 2;
                if (command.equals("ApplyButton")) {
                    response.noAction();
                } else {
                    response.dispose("EditUserPanel");
                }
                this.bounceUpdate("UserManagerPanel", map);
            }
            catch (DuplicateNameException dne) {
                if (this.mode == 1) {
                    this.duplicateMessage(user.getName());
                    response.noAction();
                }
            }
        } else if (command.equals("CancelButton")) {
            response.dispose("EditUserPanel");
        } else {
            this.unknownCommand(response, command);
        }
    }
}

